import numpy as np
import matplotlib.pyplot as plt

# Load the light curve parameters data
lc_data = np.genfromtxt('hlsp_ps1cosmo_panstarrs_gpc1_all_model_v1_lcparam-full.txt', dtype=None, names=True, delimiter='|', encoding=None)

# Extract redshift and distance modulus
z = lc_data['z']
mu = lc_data['mu']

# Define your emergent gravity model function
def emergent_gravity_model(z, k, r0, omega):
    # Implement your model here
    # For example:
    return omega * k**2 * r0 / z

# Choose parameters for your model
k = 1.0  # Example value
r0 = 1.0  # Example value
omega = 1.0  # Example value

# Calculate the model distance modulus
mu_model = emergent_gravity_model(z, k, r0, omega)

# Plot the data and model
plt.figure(figsize=(8, 6))
plt.errorbar(z, mu, fmt='o', label='Pantheon Data', alpha=0.5)
plt.plot(z, mu_model, label='Emergent Gravity Model', color='red')
plt.xlabel('Redshift (z)')
plt.ylabel('Distance Modulus (μ)')
plt.legend()
plt.grid(True)
plt.show()
